delayBombQuest = 60 * 15
timeForAttack = 60 * 5
------------------------------------------------------------------------------------------------------------------------------------
function createBombQuest()

	BombArmy = UnlimitedArmy:New({
 			Player = 2,
 			Area = 4200,
 			AutoDestroyIfEmpty = false,
 			TransitAttackMove = true,
 			Formation = UnlimitedArmy.Formations.Spear,
 			AIActive = true,
 		})
	BombArmy.SpawnerCountDown = -1
	BombArmy.Waypoint = 0
	BombArmy.LeaderSpawns = 12

    StartSimpleJob("createBombArmyBriefing")

    return true

    end

------------------------------------------------------------------------------------------------------------------------------------
function createBombArmyBriefing()

    if delayBombQuest > 0 then

        delayBombQuest = delayBombQuest -1

        if delayBombQuest == 2 then

            CreateEntity(4,Entities.PU_Serf,GetPosition("bombNpcStart"),"bombNpc")

            end

        return false

        end

    Move("bombNpc","bombNpcEnd",1000)

	briefingNpc = {}

	briefingNpc.restoreCamera = true

	briefingNpc.finished = createBombArmy

	local page = 0

	--	page #1

		page = page + 1

		briefingNpc[page] 				    = 	{}
		briefingNpc[page].title		        = 	String.Key("briefingNpc[1].title")
		briefingNpc[page].text			    =	String.Key("briefingNpc[1].text")
		briefingNpc[page].position 	        = 	GetPosition("bombNpc")
		briefingNpc[page].explore           = 	2000
		briefingNpc[page].dialogCamera	    =	true
		briefingNpc[page].npc				=	{}
		briefingNpc[page].npc.id			=	GetEntityId("bombNpc")
		briefingNpc[page].npc.isObserved	=	true

	--	page #2

		page = page + 1

		briefingNpc[page] 				= 	{}
		briefingNpc[page].text			=	String.Key("briefingNpc[2].text")
		briefingNpc[page].dialogCamera	=	true

	--	page #3

		page = page + 1

		briefingNpc[page] 				= 	{}
		briefingNpc[page].text			=	String.Key("briefingNpc[3].text")
		briefingNpc[page].dialogCamera	=	true

	--AnSu: Extra function needed, because the StartCutscne function does not support pramaters for the callback
	--AnSu: Commented because Cutscene does ot fit to position. I will talk to Ralf!
    --StartCutscene(Cutscenes[THRESHOLDONECUTSCENE],StartBriefingAfterNPCCutsceneWasPlayed)
    StartBriefing(briefingNpc)

    return true

    end
------------------------------------------------------------------------------------------------------------------------------------
function createBombArmy()

    DisableNpcMarker(GetEntityId("bombNpc"))

    StartSimpleJob("startBombArmy")

    -- start timer

    GUIQuestTools.ToggleStopWatch(timeForAttack,1)

    end
------------------------------------------------------------------------------------------------------------------------------------
function startBombArmy()

    if timeForAttack > 0 then

        timeForAttack = timeForAttack -1

        --Report("time for attack "..timeForAttack)

        return false

        end

	briefingNpc2 = {}

	briefingNpc2.restoreCamera = true

	briefingNpc2.finished = createBombQuestTroops

	local page = 0

	--	page #1

		page = page + 1

		briefingNpc2[page] 				    = 	{}
		briefingNpc2[page].title		    = 	String.Key("briefingNpc2[1].title")
		briefingNpc2[page].text			    =	String.Key("briefingNpc2[1].text")
		briefingNpc2[page].position 	    = 	GetPosition("bombNpc")
		briefingNpc2[page].explore          = 	2000
		briefingNpc2[page].dialogCamera	    =	true

    StartBriefing(briefingNpc2)

    return true

    end

------------------------------------------------------------------------------------------------------------------------------------
function createBombQuestTroops()
	
	Logic.ChangeEntityPlayerID(GetID("bombNpc"), 1)

    delayBombPeople = 5
	
	spawnpos = GetPosition("bombSpawny")
	
	BombPositions = {GetPosition("bombSpawny"),GetPosition("bombwaypoint"),GetPosition("banditLeader2"),GetPosition("player1")}
	
	BombArmy:AddCommandLuaFunc(controlBombQuest,true)

 --[[   for i = 1,12,1 do

        CreateEntity(2,Entities.PU_LeaderHeavyCavalry2,GetPosition("bombSpawny"),"bomb"..i)
		
		BombArmy:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 0, GetPosition("bombSpawny"), experience)

        end]]

    BombTriggerID = StartSimpleJob("controlBombs")
	
	Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED, nil, "TowerChecker", 1, nil, nil)

    return true

    end
------------------------------------------------------------------------------------------------------------------------------------
function TowerChecker()
	if IsDead("spawny1") then
		BombArmy:Destroy()
		BombArmy.SpawnerCountDown = nil
		return true
	end
	return false
end

function controlBombQuest(self)
	if IsDead("spawny1") then
		if XGUIEng.IsWidgetShown("StopWatch") == 1 then
			GUIQuestTools.ToggleStopWatch(0, 0)
		end
		return true
	end
	if self.SpawnerCountDown <= 0 then
			for i = 1,self.LeaderSpawns,1 do
				self:CreateLeaderForArmy(Entities.PU_LeaderHeavyCavalry2, 0, spawnpos, 3)
			end
			self.SpawnerCountDown = SpawnerCountDownCalc(self)
			GUIQuestTools.ToggleStopWatch(self.SpawnerCountDown,1)
			self.LeaderSpawns = self.LeaderSpawns + 1
	end
	self.SpawnerCountDown = self.SpawnerCountDown - 1
	if self:IsIdle() then
		return WaypointFunc(self)
	end
	return false
end

function SpawnerCountDownCalc(self)
	if self.LeaderSpawns <= 17 then
		return 480-((self.LeaderSpawns-11)*36) 
	else 
		return 300
	end
end

function WaypointFunc(self)
	if self:GetSize(false,false) == 0 then
		if self:GetSize(true,false) == 0 then
			self.Waypoint = 0
		else
			local uapos = self:GetPosition()
			local shortestRange = 10000000
			for i=0,3,1 do
				local tempdis = GetDistance(uapos,BombPositions[i+1])
				if tempdis < shortestRange then
					shortestRange = tempdis
					self.Waypoint = i
				end
			end
		end
	end
	if self.Waypoint == 0 then
		if GetDistance(self:GetPosition(),GetPosition("bombSpawny")) <= 1000 then
			self.Waypoint = 1
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("bombwaypoint"))
		end
	elseif self.Waypoint == 1 then
		if GetDistance(self:GetPosition(),GetPosition("bombwaypoint")) <= 1000 then
			self.Waypoint = 2
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("banditLeader2"))
		end
	elseif self.Waypoint == 2 then
		if GetDistance(self:GetPosition(), GetPosition("banditLeader2")) <= 1000 then
			self.Waypoint = 3
			return true, UnlimitedArmy.CreateCommandMove(GetPosition("player1"))
		end
	end
	return false 
end

function controlBombs()
	if BombArmy:IsDead() == -1 then
		return true
	end
	for ids in BombArmy:Iterator(true) do
		if GetRandom(100) > 95 then
			CreateEntity(2,Entities.XD_Bomb1,GetPosition(ids),"bang")
		end
	end
   return false
end
------------------------------------------------------------------------------------------------------------------------------------
function StartBriefingAfterNPCCutsceneWasPlayed()
	StartBriefing(briefingNpc)
	end